-- 1. Create any custom particle properties
pAge              = Allocate(1);  
pSpin             = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed   = Allocate(1); -- Allocate a TReal spin member
pVelocity       = Allocate(2) ;

-- 2. Set the particle texture and blend mode
  SetTexture("fx_tugheartparticle");
  SetBlendMode(kBlendNormal, 0);

-- 3. Set the number of particle in the system
SetNumParticles(10);

-- 4. Set up the particle initializer function
pPosition:Init(fRange(Vec2(-15,-5), Vec2(15,5)));

pScale:Init(fRange(.4,.5));

pAge:Init(fRange(0,0));

pVelocity:Init( f2dRadius(50) );

pSpin:Init( fRange( 0, 2*3.1415927 ) );

pSpinSpeed:Init( -.9,0);

StopSpouting = NewTimeout(1);
TestDone = NewTimeout(2); 

-- 5. Set up the particle animation function
pScale:Anim( fFade(pAge,pScale, 0.3, 0,  500,.9,700,.1));

-- Animate the velocity
pVelocity:Anim( pVelocity + fTimeScale(Vec2(-0,-120)) );

-- Animate the position
pPosition:Anim( pPosition + fTimeScale(pVelocity) );

pAge:Anim(pAge + fAge());

-- Spin by pSpinSpeed scaled by time
--pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );
--pUp:Anim( f2dRotation( pSpin ) );

pColor:Anim(fFade(pAge,Color(1, 1, 1, .8), 500,Color(1, 1,1, 1), 500,    Color(1,1,1,.1),250 ) );

 Anim(fExpire(fGreater(pAge,1200)));

-- 6. Defines an Upate function that create particle
function Update(ms)
  if (TestDone(ms)) then
    Done();
    return ;
  end

if StopSpouting(ms) then
  return;
end
 CreateParticles(1);

end

